/*
 * Decompiled with CFR 0.152.
 */
package ifs.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DataProperties
extends Properties {
    private boolean iSaveDefaults = false;

    public DataProperties() {
    }

    public DataProperties(Properties properties) {
        super(properties);
        this.iSaveDefaults = this.getPropertyBoolean("General.SaveDefaultProperties", false);
    }

    public DataProperties(Dictionary dictionary) {
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = dictionary.get(k);
            this.setProperty(k.toString(), v.toString());
        }
        this.iSaveDefaults = this.getPropertyBoolean("General.SaveDefaultProperties", false);
    }

    public String getProperty(String string, String string2) {
        if (!this.iSaveDefaults || this.containsPropery(string)) {
            return super.getProperty(string, string2);
        }
        if (string2 != null) {
            this.setProperty(string, string2);
        }
        return string2;
    }

    public Object setProperty(String string, String string2) {
        Object object = super.setProperty(string, string2);
        if ("General.SaveDefaultProperties".equals(string)) {
            this.iSaveDefaults = this.getPropertyBoolean("General.SaveDefaultProperties", false);
        }
        return object;
    }

    public int getPropertyInt(String string, int n) {
        try {
            if (this.containsPropery(string)) {
                return Integer.parseInt(this.getProperty(string));
            }
            if (this.iSaveDefaults) {
                this.setProperty(string, String.valueOf(n));
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.iSaveDefaults) {
                this.setProperty(string, String.valueOf(n));
            }
            return n;
        }
    }

    public long getPropertyLong(String string, long l) {
        try {
            if (this.containsPropery(string)) {
                return Long.parseLong(this.getProperty(string));
            }
            if (this.iSaveDefaults) {
                this.setProperty(string, String.valueOf(l));
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.iSaveDefaults) {
                this.setProperty(string, String.valueOf(l));
            }
            return l;
        }
    }

    public boolean containsPropery(String string) {
        return this.getProperty(string) != null;
    }

    public boolean getPropertyBoolean(String string, boolean bl) {
        try {
            if (this.containsPropery(string)) {
                return this.getProperty(string).equalsIgnoreCase("true");
            }
            if (this.iSaveDefaults) {
                this.setProperty(string, bl ? "true" : "false");
            }
            return bl;
        }
        catch (Exception exception) {
            if (this.iSaveDefaults) {
                this.setProperty(string, bl ? "true" : "false");
            }
            return bl;
        }
    }

    public double getPropertyDouble(String string, double d) {
        try {
            if (this.containsPropery(string)) {
                return Double.parseDouble(this.getProperty(string));
            }
            if (this.iSaveDefaults) {
                this.setProperty(string, String.valueOf(d));
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.iSaveDefaults) {
                this.setProperty(string, String.valueOf(d));
            }
            return d;
        }
    }

    public float getPropertyFloat(String string, float f) {
        try {
            if (this.containsPropery(string)) {
                return Float.parseFloat(this.getProperty(string));
            }
            if (this.iSaveDefaults) {
                this.setProperty(string, String.valueOf(f));
            }
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.iSaveDefaults) {
                this.setProperty(string, String.valueOf(f));
            }
            return f;
        }
    }

    public Dictionary toDict() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getProperty(string);
            if (string == null || string2 == null) continue;
            hashtable.put(string, string2);
        }
        return hashtable;
    }

    private void expand(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return;
        }
        int n = -1;
        int n2 = -1;
        while ((n2 = string2.indexOf(37, n + 1)) >= 0) {
            int n3 = string2.indexOf(37, n2 + 1);
            if (n3 < 0) {
                return;
            }
            String string3 = string2.substring(n2 + 1, n3);
            if (this.containsPropery(string3)) {
                string2 = string2.substring(0, n2) + this.getProperty(string3) + string2.substring(n3 + 1);
                continue;
            }
            n = n2;
        }
    }

    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
        Enumeration<Object> enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            this.expand((String)enumeration.nextElement());
        }
        this.iSaveDefaults = this.getPropertyBoolean("General.SaveDefaultProperties", false);
    }
}

