/*
 * Decompiled with CFR 0.152.
 */
package ifs.util;

import ifs.util.ProgressListener;
import java.io.PrintStream;

public class ProgressWriter
implements ProgressListener {
    private PrintStream iTextOut = null;
    private static int TEXT_LENGTH = 28;
    private static int DOTS_LENGTH = 48;
    private int iPrintedDots = -1;

    public ProgressWriter(PrintStream printStream) {
        this.iTextOut = printStream;
    }

    public void statusChanged(String string) {
    }

    public void phaseChanged(String string) {
        if (this.iPrintedDots > 0) {
            while (this.iPrintedDots < DOTS_LENGTH) {
                this.iTextOut.print(".");
                ++this.iPrintedDots;
            }
        }
        this.iTextOut.println();
        this.iTextOut.print(ProgressWriter.expand(string, TEXT_LENGTH, ' ', false) + ": ");
        this.iPrintedDots = 0;
        this.iTextOut.flush();
    }

    public void progressChanged(long l, long l2) {
        int n;
        int n2 = n = l2 == 0L ? 0 : (int)((long)DOTS_LENGTH * l / l2);
        while (this.iPrintedDots < n) {
            this.iTextOut.print(".");
            ++this.iPrintedDots;
        }
        this.iTextOut.flush();
    }

    public void progressSaved() {
    }

    public void progressRestored() {
    }

    private static String expand(String string, int n, char c, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string == null ? "" : (string.length() > n ? (bl ? string.substring(string.length() - n) : string.substring(0, n)) : string));
        while (stringBuffer.length() < n) {
            if (bl) {
                stringBuffer.insert(0, c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

