/*
 * Decompiled with CFR 0.152.
 */
package ifs.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class PrologFile
implements Iterator {
    private BufferedReader iBufferedReader = null;
    private Term iNextTerm = null;

    public PrologFile(String string) throws IOException {
        this.iBufferedReader = new BufferedReader(new FileReader(string));
        Term term = this.iNextTerm = this.iBufferedReader.ready() ? PrologFile.readTerm(new SpecialReader(this.iBufferedReader)) : null;
        if (this.iNextTerm == null) {
            this.iBufferedReader.close();
        } else {
            this.iBufferedReader.readLine();
        }
    }

    public static Vector readTermsFromStream(InputStream inputStream, String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Vector<Term> vector = new Vector<Term>();
        while (bufferedReader.ready()) {
            Term term = PrologFile.readTerm(new SpecialReader(bufferedReader));
            if (term != null && term.getText() != null && term.getText().startsWith(string)) {
                vector.addElement(term);
            }
            bufferedReader.readLine();
        }
        bufferedReader.close();
        return vector;
    }

    public static void writeTerms(PrintWriter printWriter, Vector vector) throws IOException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Term term = (Term)enumeration.nextElement();
            PrologFile.writeTerm(printWriter, term);
        }
    }

    private static Term readTerm(SpecialReader specialReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<Term> vector = null;
        int n = specialReader.read();
        if (n >= 0) {
            while ((char)n == '%' || (char)n == ':') {
                while ((n = specialReader.read()) >= 0 && n != 13 && n != 10) {
                }
                n = specialReader.read();
                if (n < 0 || n != 13 && n != 10) continue;
                n = specialReader.read();
            }
            if (n >= 0) {
                specialReader.flush((char)n);
            }
        }
        char c = (char)n;
        if (n >= 0) {
            while ((n = specialReader.read()) >= 0) {
                char c2 = (char)n;
                if (c2 == '\n' || c2 == '\r') {
                    if (c != '.') continue;
                    break;
                }
                if (c2 == '(' || c2 == '[') {
                    vector = new Vector<Term>();
                    vector.addElement(PrologFile.readTerm(specialReader));
                } else {
                    if (vector == null && (c2 == ',' || c2 == ')' || c2 == ']')) {
                        specialReader.flush(c2);
                        break;
                    }
                    if (c2 == ',') {
                        vector.addElement(PrologFile.readTerm(specialReader));
                    } else {
                        if (c2 == ')' || c2 == ']') break;
                        stringBuffer.append(c2);
                    }
                }
                c = c2;
            }
        } else {
            return null;
        }
        Term term = new Term(stringBuffer.toString().trim(), vector);
        return term;
    }

    private static void writeTerm(PrintWriter printWriter, Term term) {
        printWriter.println(term.toString() + ".");
    }

    public boolean hasNext() {
        return this.iNextTerm != null;
    }

    public Object next() {
        Term term = this.iNextTerm;
        try {
            this.iNextTerm = this.iBufferedReader.ready() ? PrologFile.readTerm(new SpecialReader(this.iBufferedReader)) : null;
        }
        catch (IOException iOException) {
            this.iNextTerm = null;
        }
        try {
            if (this.iNextTerm == null) {
                this.iBufferedReader.close();
            } else {
                this.iBufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return term;
    }

    public void remove() {
    }

    public static class Term {
        private String iText = null;
        private Vector iContent = null;

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Term)) {
                return false;
            }
            Term term = (Term)object;
            if (this.iText == null && term.iText != null) {
                return false;
            }
            if (this.iText != null && term.iText == null) {
                return false;
            }
            if (this.iText != null && !this.iText.equals(term.iText)) {
                return false;
            }
            if (this.iContent == null && term.iContent != null) {
                return false;
            }
            if (this.iContent != null && term.iContent == null) {
                return false;
            }
            return this.iContent == null || this.iContent.equals(term.iContent);
        }

        public Term(String string) {
            this.iText = string;
            this.iContent = null;
        }

        public Term(Vector vector) {
            this.iText = null;
            this.iContent = vector;
        }

        public Term(String string, Vector vector) {
            this.iText = string;
            this.iContent = vector;
        }

        public Term(String string, Term[] termArray) {
            this.iText = string;
            if (termArray == null) {
                this.iContent = null;
            } else {
                this.iContent = new Vector();
                for (int i = 0; i < termArray.length; ++i) {
                    this.iContent.addElement(termArray[i]);
                }
            }
        }

        public Term(Term[] termArray) {
            this(null, termArray);
        }

        public String getText() {
            return this.iText;
        }

        public Vector getContent() {
            return this.iContent;
        }

        public int size() {
            return this.iContent == null ? -1 : this.iContent.size();
        }

        public int toInt() {
            return Integer.parseInt(this.iText);
        }

        public long toLong() {
            return Long.parseLong(this.iText);
        }

        public double toDouble() {
            return Double.parseDouble(this.iText);
        }

        public boolean toBoolean() {
            return this.toInt() != 0;
        }

        public boolean[] toBooleanArray() {
            if (this.iContent.size() == 1 && this.iContent.elementAt(0).toString().length() == 0) {
                return new boolean[0];
            }
            boolean[] blArray = new boolean[this.iContent.size()];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = this.elementAt(i).toBoolean();
            }
            return blArray;
        }

        public String[] toStringArray() {
            if (this.iContent.size() == 1 && this.iContent.elementAt(0).toString().length() == 0) {
                return new String[0];
            }
            String[] stringArray = new String[this.iContent.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                Term term = this.elementAt(i);
                stringArray[i] = term.getText().length() > 0 ? term.toString() : term.elementAt(0).toString();
            }
            return stringArray;
        }

        public int[] toIntArray() {
            if (this.iContent.size() == 1 && this.iContent.elementAt(0).toString().length() == 0) {
                return new int[0];
            }
            int[] nArray = new int[this.iContent.size()];
            for (int i = 0; i < nArray.length; ++i) {
                Term term = this.elementAt(i);
                nArray[i] = term.getText().length() > 0 ? Integer.parseInt(term.getText()) : term.elementAt(0).toInt();
            }
            return nArray;
        }

        public Term elementAt(int n) {
            try {
                return (Term)this.iContent.elementAt(n);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Term element(String string) {
            try {
                Enumeration enumeration = this.iContent.elements();
                while (enumeration.hasMoreElements()) {
                    Term term = (Term)enumeration.nextElement();
                    if (term.getText() == null || !term.getText().equals(string)) continue;
                    return term;
                }
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public int indexOf(String string) {
            try {
                int n = 0;
                Enumeration enumeration = this.iContent.elements();
                while (enumeration.hasMoreElements()) {
                    Term term = (Term)enumeration.nextElement();
                    if (term.getText() != null && term.getText().equals(string)) {
                        return n;
                    }
                    ++n;
                }
                return -1;
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public String toString() {
            boolean bl = this.iText == null || this.iText.length() == 0;
            StringBuffer stringBuffer = new StringBuffer(bl ? "" : this.iText);
            if (this.iContent != null) {
                stringBuffer.append(bl ? "[" : "(");
                Enumeration enumeration = this.iContent.elements();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(enumeration.nextElement().toString());
                    stringBuffer.append(enumeration.hasMoreElements() ? "," : "");
                }
                stringBuffer.append(bl ? "]" : ")");
            }
            return stringBuffer.toString();
        }

        public Object clone() {
            return new Term(this.iText == null ? null : new String(this.iText), this.iContent == null ? this.iContent : (Vector)this.iContent.clone());
        }
    }

    private static class SpecialReader {
        private Reader iReader = null;
        private StringBuffer iFlushedChars = new StringBuffer();

        public SpecialReader(Reader reader) {
            this.iReader = reader;
        }

        public int read() throws IOException {
            if (this.iFlushedChars.length() == 0) {
                return this.iReader.read();
            }
            char c = this.iFlushedChars.charAt(0);
            this.iFlushedChars.deleteCharAt(0);
            return c;
        }

        public void flush(char c) {
            this.iFlushedChars.insert(0, c);
        }
    }
}

