/*
 * Decompiled with CFR 0.152.
 */
package ifs.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class Queue {
    private Object[] iElementData;
    private int iMaxSize;
    private int iFirst;
    private int iLast;
    private HashSet iHashedElementData;

    public Queue(int n) {
        this.iMaxSize = n + 2;
        this.iLast = 0;
        this.iFirst = 0;
        this.iElementData = new Object[this.iMaxSize];
        this.iHashedElementData = new HashSet(2 * this.iMaxSize, 0.5f);
    }

    public Queue(int n, Collection collection) {
        this(n);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.put(iterator.next());
        }
    }

    public void put(Object object) throws ArrayIndexOutOfBoundsException {
        this.iElementData[this.iLast] = object;
        this.iHashedElementData.add(object);
        this.iLast = (this.iLast + 1) % this.iMaxSize;
        if (this.iFirst == this.iLast) {
            throw new ArrayIndexOutOfBoundsException("Queue is full.");
        }
    }

    public boolean contains(Object object) {
        return this.iHashedElementData.contains(object);
    }

    public Object get() {
        if (this.iLast == this.iFirst) {
            return null;
        }
        Object object = this.iElementData[this.iFirst];
        this.iFirst = (this.iFirst + 1) % this.iMaxSize;
        this.iHashedElementData.remove(object);
        return object;
    }

    public int size() {
        return this.iLast >= this.iFirst ? this.iLast - this.iFirst : this.iMaxSize + this.iLast - this.iFirst;
    }

    public boolean isEmpty() {
        return this.iFirst == this.iLast;
    }
}

