/*
 * Decompiled with CFR 0.152.
 */
package ifs.util;

import ifs.util.DataProperties;
import ifs.util.FastVector;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ToolBox {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$util$ToolBox == null ? (class$ifs$util$ToolBox = ToolBox.class$("ifs.util.ToolBox")) : class$ifs$util$ToolBox));
    private static long sSeed = System.currentTimeMillis();
    private static Random sRandom = new Random(sSeed);
    static /* synthetic */ Class class$ifs$util$ToolBox;

    public static int random(int n) {
        return (int)(ToolBox.random() * (double)n);
    }

    public static Object random(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        Vector vector = collection instanceof Vector ? (Vector)collection : new Vector(collection);
        return vector.elementAt(ToolBox.random(vector.size()));
    }

    public static Collection subSet(Collection collection, double d) {
        return ToolBox.subSet(collection, d, 1);
    }

    private static void swap(ArrayList arrayList, int n, int n2) {
        Object e = arrayList.get(n);
        arrayList.set(n, arrayList.get(n2));
        arrayList.set(n2, e);
    }

    public static Collection subSet(Collection collection, double d, int n) {
        if (collection.size() <= n || d >= 1.0) {
            return collection;
        }
        ArrayList arrayList = new ArrayList(collection);
        int n2 = collection.size();
        int n3 = Math.max(n, (int)(d * (double)collection.size()));
        for (int i = 0; i < n3; ++i) {
            ToolBox.swap(arrayList, i, i + (int)(ToolBox.random() * (double)(n2 - i)));
        }
        return arrayList.subList(0, n3);
    }

    public static String trim(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String col2string(Collection collection, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (stringBuffer.length() < 2 * n) {
            stringBuffer.append("  ");
        }
        StringBuffer stringBuffer2 = new StringBuffer("[\n");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuffer2.append(stringBuffer + "  " + iterator.next() + (iterator.hasNext() ? "," : "") + "\n");
        }
        stringBuffer2.append(stringBuffer + "]");
        return stringBuffer2.toString();
    }

    public static String dict2string(Dictionary dictionary, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (stringBuffer.length() < 2 * n) {
            stringBuffer.append("  ");
        }
        StringBuffer stringBuffer2 = new StringBuffer("[\n");
        Enumeration enumeration = ToolBox.sortEnumeration(dictionary.keys());
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object v = dictionary.get(e);
            stringBuffer2.append(stringBuffer + "  " + e + ": " + v + "\n");
        }
        stringBuffer2.append(stringBuffer + "]");
        return stringBuffer2.toString();
    }

    public static double rms(int n, double d, double d2) {
        double d3 = d2 / (double)n;
        double d4 = d / (double)n;
        return Math.sqrt(Math.abs(d3 - d4 * d4));
    }

    public static Enumeration sortEnumeration(Enumeration enumeration) {
        return ToolBox.sortEnumeration(enumeration, null);
    }

    public static Enumeration sortEnumeration(Enumeration enumeration, Comparator comparator) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Collections.sort(vector, comparator);
        return vector.elements();
    }

    public static void merge(Vector vector, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (vector.contains(e)) continue;
            vector.addElement(e);
        }
    }

    public static Vector intersect(Collection collection, Collection collection2) {
        FastVector fastVector = new FastVector();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection2.contains(e)) continue;
            fastVector.addElement(e);
        }
        return fastVector;
    }

    public static void setSeed(long l) {
        sSeed = l;
        sRandom = new Random(sSeed);
    }

    public static long getSeed() {
        return sSeed;
    }

    public static Random getRandom() {
        return sRandom;
    }

    public static double random() {
        return sRandom.nextDouble();
    }

    public static void configureLogging() {
        Properties properties = new Properties();
        properties.setProperty("log4j.rootLogger", "DEBUG, A1");
        properties.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        properties.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-5p %c{2}: %m%n");
        PropertyConfigurator.configure((Properties)properties);
    }

    public static void configureLogging(String string, Properties properties) {
        ToolBox.configureLogging(string, properties, false);
    }

    public static void configureLogging(String string, Properties properties, boolean bl) {
        Properties properties2;
        String string2 = new SimpleDateFormat("yyyy-MM-dd_(HH.mm.ss)", Locale.US).format(new Date());
        new File(string).mkdirs();
        String string3 = string + File.separator + (bl ? "debug_" + string2 : "debug") + ".log";
        Properties properties3 = properties2 = properties != null ? properties : new Properties();
        if (!properties2.containsKey("log4j.rootLogger")) {
            properties2.setProperty("log4j.rootLogger", "debug, LogFile");
            properties2.setProperty("log4j.appender.LogFile", "org.apache.log4j.RollingFileAppender");
            properties2.setProperty("log4j.appender.LogFile.MaxFileSize", "5MB");
            properties2.setProperty("log4j.appender.LogFile.File", string3);
            properties2.setProperty("log4j.appender.LogFile.MaxBackupIndex", "5");
            properties2.setProperty("log4j.appender.LogFile.layout", "org.apache.log4j.PatternLayout");
            properties2.setProperty("log4j.appender.LogFile.layout.ConversionPattern", "%d{dd-MMM-yy HH:mm:ss.SSS} [%t] %-5p %c{2}> %m%n");
        }
        PropertyConfigurator.configure((Properties)properties2);
        Logger logger = Logger.getRootLogger();
        logger.info((Object)"IFS debug file");
        logger.info((Object)"");
        logger.info((Object)("Created: " + new Date()));
        logger.info((Object)"");
        logger.info((Object)"System info:");
        logger.info((Object)("System:      " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch")));
        logger.info((Object)("CPU:         " + System.getProperty("sun.cpu.isalist") + " endian:" + System.getProperty("sun.cpu.endian") + " encoding:" + System.getProperty("sun.io.unicode.encoding")));
        logger.info((Object)("Java:        " + System.getProperty("java.vendor") + ", " + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version", System.getProperty("java.version"))));
        logger.info((Object)("User:        " + System.getProperty("user.name")));
        logger.info((Object)("Timezone:    " + System.getProperty("user.timezone")));
        logger.info((Object)("Working dir: " + System.getProperty("user.dir")));
        logger.info((Object)("Classpath:   " + System.getProperty("java.class.path")));
        logger.info((Object)"");
    }

    public static DataProperties loadProperties(File file) {
        try {
            DataProperties dataProperties = new DataProperties();
            FileInputStream fileInputStream = new FileInputStream(file);
            dataProperties.load(fileInputStream);
            fileInputStream.close();
            if (dataProperties.getProperty("INCLUDE") != null) {
                fileInputStream = null;
                StringTokenizer stringTokenizer = new StringTokenizer(dataProperties.getProperty("INCLUDE"), ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    System.out.println("  Loading included file '" + string + "' ... ");
                    if (new File(string).exists()) {
                        fileInputStream = new FileInputStream(string);
                    }
                    if (new File(file.getParent() + File.separator + string).exists()) {
                        fileInputStream = new FileInputStream(file.getParent() + File.separator + string);
                    }
                    if (fileInputStream == null) {
                        System.err.println("Unable to find include file '" + string + "'.");
                    }
                    dataProperties.load(fileInputStream);
                    fileInputStream.close();
                }
                dataProperties.remove("INCLUDE");
            }
            return dataProperties;
        }
        catch (Exception exception) {
            System.err.println("Unable to load property file " + file);
            exception.printStackTrace();
            return new DataProperties();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

