package ifs.example.csp;

import java.util.*;

/**
 * CSP variable.
 * <br><br>
 * This class only implements generation of variable's values (domain)
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */
public class CSPVariable extends ifs.model.Variable {
    private int iKernelId=-1;
    private int iId = 0;
    
    /**
     * Constructor
     * @param domainSize number of values of the variable
     */
    public CSPVariable(int id, int domainSize) {
        this(id, domainSize, -1);
    }

    /**
     * Constructor
     * @param domainSize number of values of the variable
     * @param kernelId kernel id (for structured CSP)
     */
    public CSPVariable(int id, int domainSize, int kernelId) {
        super(null);
        iId = id;
        iKernelId = kernelId;
        setValues(computeValues(domainSize));
    }
    
    /** Get kernel id */
    public int getKernelId() { return iKernelId; }
    
    /** Generate an intial value (for MPP and for forcing of existance of a solution) */
    public void generateInitialValue(Random rnd) {
        CSPValue aValue = (CSPValue)values().elementAt((int)(rnd.nextFloat()*values().size()));
        setInitialAssignment(aValue);
    }
    
    private Vector computeValues(int domainSize) {
        Vector values = new Vector();
        for (int i=0; i< domainSize; i++) {
            CSPValue value = new CSPValue(this, i);
            values.addElement(value);
        }
        return values;
    }
    
    public String getName() { return "V"+getId(); }
}
