package ifs.example.jobshop;

import ifs.model.*;

/**
 * Location of an operation.
 * <br><br>
 * Each location has its start time.
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */
public class Location extends Value {
    private int iStartTime = -1;
    
    /**
     * Constructor
     * @param op parent operation
     * @param startTime start time
     */
    public Location(Operation op, int startTime) {
        super(op);
        iStartTime = startTime;
    }
    
    /**
     * Get start time of the location
     */
    public int getStartTime() { return iStartTime; }
    
    /**
     * Get finishing time of the location (start time + operation processing time)
     */
    public int getFinishingTime() { return iStartTime+((Operation)variable()).getProcessingTime()-1; }
    
    /**
     * Start time of the location
     */
    public int toInt() { return iStartTime; }
    
    /**
     * String representation (operation name = start time)
     */
    public String toString() { return variable().getName()+"="+iStartTime; }
    
    /**
     * Name -- start time
     */
    public String getName() { return String.valueOf(iStartTime); }
    
    /**
     * Returns true if overlap with the given location
     */
    public boolean overlap(Location anotherLocation) {
        if (getStartTime()+((Operation)variable()).getProcessingTime()<=anotherLocation.getStartTime()) return false;
        if (anotherLocation.getStartTime()+((Operation)anotherLocation.variable()).getProcessingTime()<=getStartTime()) return false;
        return true;
    }
    
    /**
     * Returnts true if before the given location
     */
    public boolean before(Location anotherLocation) {
        if (getStartTime()+((Operation)variable()).getProcessingTime()<=anotherLocation.getStartTime()) return true;
        return false;
    }

    /**
     * Returnts true if after the given location
     */
    public boolean after(Location anotherLocation) {
        return anotherLocation.before(this);
    }
}
