package ifs.example.jobshop;

import ifs.model.*;
import ifs.solver.*;
import ifs.solution.*;
import ifs.util.*;
import java.io.*;
import java.util.*;

/**
 * Test of Job Shop problem. It takes one argument -- property file with all the parameters.
 * <br><br>
 * Test's parameters:
 * <br>
 * <table border='1'><tr><th>Parameter</th><th>Type</th><th>Comment</th></tr>
 * <tr><td>General.Input</td><td>{@link String}</td><td>Input file describing the job shop problem</td></tr>
 * <tr><td>General.Output</td><td>{@link String}</td><td>Output folder where a log file and a solution (solution.txt) will be placed</td></tr>
 * </table>
 * <br>
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */
public class Test {
    private static java.text.DecimalFormat sDoubleFormat = new java.text.DecimalFormat("0.00",new java.text.DecimalFormatSymbols(Locale.US));
    private static java.text.SimpleDateFormat sDateFormat = new java.text.SimpleDateFormat("dd-MMM-yy_HHmmss",java.util.Locale.US);
    private static org.apache.log4j.Logger sLogger = org.apache.log4j.Logger.getLogger(Test.class);

    public static void test(DataProperties properties) {
        try {
            String inputFile = properties.getProperty("General.Input");
            JobShopModel model = JobShopModel.loadModel(inputFile);
            Solver s = new Solver(properties);
            s.setInitalSolution(model);
            s.start();
            s.getSolverThread().join();
            Solution best = s.currentSolution();
            best.restoreBest();
            sLogger.info("Best solution info:"+best.getInfo());
            sLogger.info("Best solution:"+model.toString());
            model.save(properties.getProperty("General.Output")+File.separator+"solution.txt");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public static void main(String[] args) {
        try {
            Progress.getInstance().addProgressListener(new ProgressWriter(System.out));
            
            File inputCfg = new File(args[0]);
            DataProperties properties = ToolBox.loadProperties(inputCfg);
            String outDir = properties.getProperty("General.Output",".")+File.separator + inputCfg.getName().substring(0,inputCfg.getName().lastIndexOf('.'))+File.separator+sDateFormat.format(new Date());
            (new File(outDir)).mkdirs();
            properties.setProperty("General.Output", outDir.toString());
            ToolBox.configureLogging(outDir, null);
            test(properties);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
