package ifs.model;

import java.util.*;

/**
 * IFS constraint listener.
 *
 * @see Constraint
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */
public interface ConstraintListener {
    /** Called by the constraint, before a value is assigned to its variable.
     * @param iteration current iteration
     * @param constraint source constraint
     * @param assigned value which will be assigned to its variable ({@link Value#variable()})
     * @param unassigned set of conflicting values which will be unassigned by the constraint before it assigns the given value
     */
    public void constraintBeforeAssigned(long iteration, Constraint constraint, Value assigned, Set unassigned);

    /** Called by the constraint, after a value is assigned to its variable.
     * @param iteration current iteration
     * @param constraint source constraint
     * @param assigned value which was assigned to its variable ({@link Value#variable()})
     * @param unassigned set of conflicting values which were unassigned by the constraint before it assigned the given value
     */
    public void constraintAfterAssigned(long iteration, Constraint constraint, Value assigned, Set unassigned);
}