package ifs.solution;

/**
 * IFS solution comparator.
 * <br><br>
 * The solution comparator compares two solutions: the current solution and the best solution found. This comparison can
 * be based on several criteria. For example, it can lexicographically order solutions according to the number of 
 * unassigned variables (smaller number is better) and the number of violated soft constraints.
 *
 * @see Solution
 * @see ifs.solver.Solver
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */
public interface SolutionComparator {
    /** Compares two solutions. Returns true if the given solution is better than its best ever found solution (see {@link Solution#saveBest()} and {@link Solution#restoreBest()}).
     * @param currentSolution given solution
     * @return true if the given solution is better than the best ever found solution
     */
    public boolean isBetterThanBestSolution(Solution currentSolution);
}
