package ifs.termination;

import ifs.solution.Solution;

/**
 * Termination condition.
 * <br><br>
 * The termination condition determines when the algorithm should finish. For example, 
 * the solver should terminate when the maximal number of iterations or some other given 
 * timeout value is reached. Moreover, it can stop the search process when the current 
 * solution is good enough, e.g., all variables are assigned and/or some other solution 
 * parameters are in the required ranges. For example, the solver can stop when all 
 * variables are assigned and less than 10% of the soft constraints are violated. 
 * Termination of the process by the user can also be a part of the termination condition.
 *
 * @see ifs.solver.Solver
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 **/
public interface TerminationCondition {
    /** Returns true when the solver can continue with the next iteration
     * @param currentSolution current solution
     */
    public boolean canContinue(Solution currentSolution);
}
