package ifs.util;

/**
 * Progress bar listener.
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */
public interface ProgressListener {
    /** Progress status is changed 
     * @param status current status name
     */
    public void statusChanged(String status);
    /** Progress phase is changed 
     * @param phase current phase name
     */
    public void phaseChanged(String phase);
    /** Progress bar is changed
     * @param currentProgress current progress
     * @param maxProgress maximum progress in this phase
     */
    public void progressChanged(long currentProgress, long maxProgress);
    /** Progress is saved */
    public void progressSaved();
    /** Progress is restored */
    public void progressRestored();
}
