package ifs.util;

import java.io.PrintStream;

/** Prints current progres to {@link PrintStream}.
 * <br><br>
 * Example usage:<ul><code>
 * Progress.getInstance().addProgressListener(new ProgressWriter(System.out));<br>
 * </code></ul>
 * <br>
 * Example output:<ul><code>
 * Reading course.pl ...       :<br>
 * Reading altcourse.pl ...    :<br>
 * Reading room.pl ...         :<br>
 * Creating rooms ...          : ................................................<br>
 * Creating variables ...      : ................................................<br>
 * Reading students.pl ...     :<br>
 * Reading jenr.pl ...         :<br>
 * Creating jenrl constraints .: ................................................<br>
 * Reading add.pl ...          :<br>
 * Creating group constraints .: ................................................<br>
 * Creating initial assignment : ................................................<br>
 * Creating dept. spread constr: ................................................<br>
 * Input data loaded           : ................................................<br>
 * Initializing solver         :<br>
 * Searching for initial soluti: ................................................<br>
 * Improving found solution ...: ................................................<br>
 * Improving found solution ...: ................................................<br>
 * Improving found solution ...: ...................................
 * </code></ul>
 *
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
*/
public class ProgressWriter implements ProgressListener {
    private PrintStream iTextOut = null;
    private static int TEXT_LENGTH = 28;
    private static int DOTS_LENGTH = 48;
    private int iPrintedDots = -1;

    public ProgressWriter(PrintStream out) {
        iTextOut = out;
    }
    
    public void statusChanged(String status) {
        //iTextOut.println("Status: "+status);
    }

    public void phaseChanged(String phase) {
        if (iPrintedDots>0) {
            while (iPrintedDots<DOTS_LENGTH) { iTextOut.print("."); iPrintedDots++; }
        }
        iTextOut.println();
        iTextOut.print(expand(phase,TEXT_LENGTH,' ',false)+": ");
        iPrintedDots = 0;
        iTextOut.flush();
    }
    
    public void progressChanged(long currentProgress, long maxProgress) {
        int dotsToPrint = (maxProgress==0?0:(int)((DOTS_LENGTH*currentProgress)/maxProgress));
        while (iPrintedDots<dotsToPrint) {
            iTextOut.print(".");
            iPrintedDots++;
        }
        iTextOut.flush();
    }

    public void progressSaved() {}
    public void progressRestored() {}    
    
    private static String expand(String source, int length, char ch, boolean beg) {
        StringBuffer sb = new StringBuffer(source==null?"":source.length()>length?(beg?source.substring(source.length()-length):source.substring(0,length)):source);
        while (sb.length()<length) {
            if (beg) sb.insert(0,ch); else sb.append(ch);
        }
        return sb.toString();
    }
}
