package ttsolver.model;

/**
 * Room part of placement.
 * <br><br>
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */

public class RoomLocation {
    private int iPreference;
    private String iName;
    private String iId;
    private String iBldgId;
    private long iRoomSize;
    private long iPosX = 0, iPosY = 0;
    
    /** Constructor
     * @param id room id
     * @param name room name
     * @param bldgId building id
     * @param preference soft preference
     * @param size room size
     * @param x x-position of the building
     * @param y y-position of the building
     */
    public RoomLocation(String id, String name, String bldgId, int preference, long size, long x, long y) {
        iId = id;
        iName = name;
        iPreference = preference;
        iRoomSize = size;
        iPosX = x; iPosY = y;
        iBldgId = bldgId;
    }
    
    /** Constructor
     * @param id room id
     * @param name room name
     * @param bldgId building id
     * @param preference soft preference
     * @param size room size
     */
    public RoomLocation(String id, String name, String bldgId, int preference, long size) {
        this(id, name, bldgId, preference, size, 0L, 0L);
    }
    
    /** Room id */
    public String getId() { return iId; }
    /** Building id */
    public String getBuildingId() { return iBldgId; }
    /** Room name */
    public String getName() { return iName; }
    /** Room preference */
    public int getPreference() { return iPreference; }
    /** Room size */
    public long getRoomSize() { return iRoomSize; }
    /** Position of the building */
    public void setCoordinates(long x, long y) { iPosX=x; iPosY=y; }
    /** X-position of the building */
    public long getPosX() { return iPosX; }
    /** Y-position of the building */
    public long getPosY() { return iPosY; }
    
    public String toString() {
        return "Room{name="+iName+", pref="+iPreference+"}";
    }
}
